// GMSH script to generate the mesh for a simple 3d beam
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 07/02/2023


//parameters
l1 = 20.0;		//x domain size (extrusion width)
l2 = 1.0;		//y domain size (layer height)
l3 = 1.0;		//z domain size (extrusion length)

surfaceMeshSize = 0.2;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {l1, 0, 0, surfaceMeshSize};
Point(3) = {l1, l2, 0, surfaceMeshSize};
Point(4) = {0, l2, 0, surfaceMeshSize};

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 1};

Curve Loop(1) = {1, 2, 3, 4};
Plane Surface(1) = {1};
Extrude {0, 0, l3} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; 
}
Curve Loop(6) = {7, 9, 11, 12};
Plane Surface(6) = {6};
Surface Loop(1) = {5, 4, 3, 2, 6, 1};
Volume(1) = {1};
